/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.createtweaker.managers;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.recipe.ActionAddRecipe;
import com.blamejared.crafttweaker.api.action.recipe.ActionRecipeBase;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.ingredient.IIngredientWithAmount;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.random.Percentaged;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.blamejared.createtweaker.managers.base.IProcessingRecipeManager;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.contraptions.components.mixer.MixingRecipe;
import com.simibubi.create.content.contraptions.processing.HeatCondition;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipeBuilder;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.fluids.FluidStack;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.create.MixingManager")
@Document(value="mods/createtweaker/MixingManager")
public class MixingManager
implements IProcessingRecipeManager<MixingRecipe> {
    @ZenCodeType.Method
    public void addRecipe(String name, HeatCondition heat, Percentaged<IItemStack>[] outputs, IIngredientWithAmount[] itemInputs, @ZenCodeType.Optional(value="[] as crafttweaker.api.fluid.IFluidStack[]") IFluidStack[] fluidInputs, @ZenCodeType.OptionalInt(value=100) int duration) {
        name = this.fixRecipeName(name);
        ResourceLocation resourceLocation = new ResourceLocation("crafttweaker", name);
        ProcessingRecipeBuilder builder = new ProcessingRecipeBuilder(this.getSerializer().getFactory(), resourceLocation);
        for (Percentaged<IItemStack> output : outputs) {
            builder.output((float)output.getPercentage(), ((IItemStack)output.getData()).getInternal());
        }
        ArrayList ingredients = new ArrayList();
        Arrays.stream(itemInputs).forEach(iIngredientWithAmount -> {
            for (int i = 0; i < iIngredientWithAmount.getAmount(); ++i) {
                ingredients.add(iIngredientWithAmount.getIngredient().asVanillaIngredient());
            }
        });
        builder.withItemIngredients(ingredients.toArray(new Ingredient[0]));
        if (fluidInputs != null && fluidInputs.length != 0) {
            builder.withFluidIngredients((FluidIngredient[])Arrays.stream(fluidInputs).map(iFluidStack -> FluidIngredient.fromFluidStack((FluidStack)iFluidStack.getInternal())).toArray(FluidIngredient[]::new));
        }
        builder.requiresHeat(heat);
        builder.duration(duration);
        MixingRecipe recipe = (MixingRecipe)builder.build();
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, (Recipe)recipe));
    }

    @ZenCodeType.Method
    public void addRecipe(String name, HeatCondition heat, IFluidStack[] outputs, IIngredientWithAmount[] itemInputs, @ZenCodeType.Optional(value="[] as crafttweaker.api.fluid.IFluidStack[]") IFluidStack[] fluidInputs, @ZenCodeType.OptionalInt(value=100) int duration) {
        name = this.fixRecipeName(name);
        ResourceLocation resourceLocation = new ResourceLocation("crafttweaker", name);
        ProcessingRecipeBuilder builder = new ProcessingRecipeBuilder(this.getSerializer().getFactory(), resourceLocation);
        for (IFluidStack output : outputs) {
            builder.output(output.getInternal());
        }
        ArrayList ingredients = new ArrayList();
        Arrays.stream(itemInputs).forEach(iIngredientWithAmount -> {
            for (int i = 0; i < iIngredientWithAmount.getAmount(); ++i) {
                ingredients.add(iIngredientWithAmount.getIngredient().asVanillaIngredient());
            }
        });
        builder.withItemIngredients(ingredients.toArray(new Ingredient[0]));
        if (fluidInputs != null) {
            builder.withFluidIngredients((FluidIngredient[])Arrays.stream(fluidInputs).map(iFluidStack -> FluidIngredient.fromFluidStack((FluidStack)iFluidStack.getInternal())).toArray(FluidIngredient[]::new));
        }
        builder.requiresHeat(heat);
        builder.duration(duration);
        MixingRecipe recipe = (MixingRecipe)builder.build();
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, (Recipe)recipe));
    }

    @ZenCodeType.Method
    public void remove(final IFluidStack output) {
        CraftTweakerAPI.apply((IAction)new ActionRecipeBase<MixingRecipe>((IRecipeManager)this){

            public void apply() {
                ArrayList<ResourceLocation> toRemove = new ArrayList<ResourceLocation>();
                for (ResourceLocation location : this.getManager().getRecipes().keySet()) {
                    MixingRecipe recipe = (MixingRecipe)this.getManager().getRecipes().get(location);
                    if (recipe.getFluidResults().isEmpty()) continue;
                    FluidStack fluidStack = (FluidStack)recipe.getFluidResults().get(0);
                    if (!output.getInternal().isFluidEqual(fluidStack)) continue;
                    toRemove.add(location);
                }
                toRemove.forEach(this.getManager().getRecipes()::remove);
            }

            public String describe() {
                return "Removing \"" + Registry.f_122864_.m_7981_((Object)this.getManager().getRecipeType()) + "\" recipes with output: " + output + "\"";
            }
        });
    }

    @Override
    public AllRecipeTypes getCreateRecipeType() {
        return AllRecipeTypes.MIXING;
    }
}

